dnl Copyright (c) 2005 Umetrics AB
dnl Part of SIMCA QuickModelling example code. 

AC_DEFUN([AC_PATH_SIMCAQ],
[
   AC_MSG_CHECKING(for SIMCA QuickModelling)

   ac_umsqm="no"

   AC_ARG_WITH(simcaq,
     [  --with-simcaq     where SIMCA QuickModelling is located. ],
     [  ac_umsqm="$withval" ])

   dnl Did the user give --with-simcaq
    
   if test "$ac_umsqm" = no; then
       dnl No they didn't, so lets look for them...
    
       if test "x$SIMCAQDIR" != x; then
          ac_umsqm="$SIMCAQDIR"
       else
          dnl Check if sqp can be found globally
          dnl If not, try to find sqp in various places.
          AC_CHECK_LIB(simcaq, SQM_AddProject, 
                       [SIMCAQLIBS="-lsimcaq"
                        have_umsqm="yes"],
                       [umsqm_library_dirs="\
                                           ../../.libs \
                                           ../../sqm/.libs \
                                           ../../../.libs \
                                           ../../../sqm/.libs \
                                           ../unix/.libs \
                                           ../../unix/.libs \
                                           ../../../unix/.libs \
                                           ../.libs \
                                           /usr/local/lib \
                                           /usr/lib/simcaq/lib \
                                           /usr/local/lib/simcaq/lib"
                         for simcaq_dir in $umsqm_library_dirs; do
                             for umsqm_check_lib in $simcaq_dir/libsimcaq*.so*; do
                                 if test -r $umsqm_check_lib; then
                                     echo Found lib $simcaq_dir
                                     sqm_libraries=$simcaq_dir
                                     have_umsqm="yes"
                                     SIMCAQLIBS="-lsimcaq"
                                     SIMCAQLDFLAGS=-L$simcaq_dir
                                     break 2
                                 fi
                             done
                         done])
          AC_CHECK_HEADER(SQMCInterface.h,
                          [have_umsqm="yes"],
                          [umsqm_include_dirs="\
                                              /usr/local/include \
                                              .. \
                                              ../../../sqm/libs/predictor/interface \
                                              ../../libs/predictor/interface \
                                              ../../../libs/predictor/interface \
                                              /usr/lib/simcaq/include \
                                              /usr/local/lib/simcaq/include"
                            echo Searching for include dirs
                            for simcaq_dir in $umsqm_include_dirs; do
                               if test -r $simcaq_dir/SQMCInterface.h; then
                                   echo Found include $simcaq_dir
                                   have_umsqm="yes"
                                   SIMCAQCPPFLAGS=-I$simcaq_dir
                                   break
                               fi
                            done])
          AC_CHECK_HEADER(SQPCInterface.h,
                          [have_umsqp="yes"],
                          [umsqp_include_dirs="\
                                              /usr/local/include \
                                              .. \
                                              ../../../libs/predictor/interface \
                                              ../../libs/predictor/interface \
                                              /usr/lib/simcaq/include \
                                              /usr/local/lib/simcaq/include"
                            for umsqp_dir in $umsqp_include_dirs; do
                               if test -r $umsqp_dir/SQPCInterface.h; then
                                   echo Found include $umsqp_dir
                                   have_umsqp="yes"
                                   SIMCAQCPPFLAGS="$SIMCAQCPPFLAGS -I$umsqp_dir"
                                   break
                               fi
                            done])
       fi
   else
           have_umsqm="yes"

           SIMCAQLDFLAGS="-L$ac_umsqm/lib"
           SIMCAQLIBS="-lsimcaq"
           SIMCAQCPPFLAGS="-I$ac_umsqm/include"
   fi
   AC_MSG_RESULT([$ac_umsqm])
   AC_SUBST(SIMCAQLIBS)
   AC_SUBST(SIMCAQLDFLAGS)
   AC_SUBST(SIMCAQCPPFLAGS)
])
